#include <Servo.h>

Servo servo;                   // Crear un objeto tipo Servo llamado servo
int angulo = 90;               // Empezamos en el centro
int salto = 1;                 // Controla el salto por movimiento

void setup() {
  servo.attach(6);  // Conectar servo al pin 6
  servo.write(angulo);
  Serial.begin(9600);
}

void loop() {
  int ejeX = analogRead(A1);  // Leemos la entrada del joystick
  ejeX = constrain(ejeX, 0, 1024);  // Evitamos que el valor del ejeX se salga de estos parametros
  angulo = constrain(angulo, 0, 180);  // Evitamos que el angulo se salga de estos parametros
  //Serial.println(ejeX);

  // Si no se mueve el joystick dejamos el servo como esta
  if (ejeX > 505 && ejeX < 520) {
    servo.write(angulo);  // Le indicamos a cuantos grados se tiene que poner el servo
  }
  // Controla la disminucion del angulo dependiendo de cuanto accionemos el joystick
  else if (ejeX < 505) {
    if (ejeX > 435) {salto = 1;}
    else if (ejeX > 335) {salto = 3;}
    else if (ejeX > 235) {salto = 7;}
    else if (ejeX > 135) {salto = 9;}
    else {salto = 15;}
    angulo -= salto;  // disminuimos el angulo
    servo.write(angulo);  // Le indicamos a cuantos grados se tiene que poner el servo
    //Serial.println("Menos angulo");
  }
  // Controla el aumento del angulo dependiendo de cuanto accionemos el joystick
  else if (ejeX > 520) {
    if (ejeX < 650) {salto = 1;}
    else if (ejeX < 750) {salto = 3;}
    else if (ejeX < 850) {salto = 7;}
    else if (ejeX < 950) {salto = 9;}
    else {salto = 15;}
    angulo += salto ;  // Aumentamos el angulo
    servo.write(angulo);  // Le indicamos a cuantos grados se tiene que poner el servo
    //Serial.println("Mas angulo");
  }
  delay(75);  // Este delay regula la velocidad de lectura del joystick
}
